<?php

namespace Opencart\Admin\Model\Extension\productOrderSerialNumber\Module;

class SerialNumber extends \Opencart\System\Engine\Model
{

	private function write(string $message): void
	{

		fwrite(fopen(DIR_LOGS . 'serials.log', 'a'), date('Y-m-d G:i:s') . ' - ' . print_r($message, true) . "\n");
	}

	public function getOrderProductName(int $order_product_id): string
	{
		$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "order_product WHERE order_product_id = '" . $order_product_id . "'");

		if ($query->num_rows) {
			return $query->row['name'];
		}
	}

	public function restoreProductSerials(int $order_product_id, int $order_id): void
	{

		$serials = $this->db->query("SELECT serial FROM " . DB_PREFIX . "order_product_serial_numbers WHERE found = 1 and order_product_id=" . $order_product_id);

		// get order product all serials
		$products_serials = $this->db->query("SELECT serial FROM " . DB_PREFIX . "order_product_serial_numbers WHERE order_product_id = " . $order_product_id);

		$product_id = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_product_id=" . $order_product_id)->row['product_id'];

		foreach ($serials->rows as $value) {
			$this->db->query("INSERT into " . DB_PREFIX . "product_serial_numbers set serial= '" . $value['serial'] . "', product_id=" . $product_id);
		}

		$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "order_product WHERE order_product_id = '" . $order_product_id . "'");

		if ($query->num_rows) {
			$product_name =  $query->row['name'];
		}

		foreach ($products_serials->rows as $value) {
			$this->write('Product(' . $product_name . ') serial "' . $value['serial'] . '" is removed from Order# ' . $order_id);
		}

		$this->db->query("DELETE  FROM " . DB_PREFIX . "order_product_serial_numbers WHERE order_product_id=" . $order_product_id);
	}

	public function getOrderProducts(int $order_id): array
	{
		return $this->db->query("SELECT op.*, p.require_serial FROM " . DB_PREFIX . "order_product op JOIN " . DB_PREFIX . "product p ON(op.product_id = p.product_id) WHERE op.order_id = '" . $order_id . "'")->rows;
	}


	public function getProductSerials(int $product_id): array
	{
		return $this->db->query("SELECT serial FROM " . DB_PREFIX . "product_serial_numbers WHERE product_id = '" . $product_id . "'")->rows;
	}


	public function getProductSerialsByOrderProduct(int $order_product_id): array
	{
		$product = $this->db->query("SELECT product_id FROM " . DB_PREFIX . "order_product WHERE order_product_id = $order_product_id")->row;

		return $this->db->query("SELECT distinct psn.serial FROM " . DB_PREFIX . "order o JOIN " . DB_PREFIX . "order_product op ON(o.order_id = op.order_id) JOIN " . DB_PREFIX . "product_serial_numbers psn ON(op.product_id = psn.product_id) WHERE psn.product_id = " . $product['product_id'] . "")->rows;
	}


	public function getOrdersByProductSerial(string $serial): array
	{
		return $this->db->query("SELECT opsn.*, op.*, o.*,oh.*,os.name AS order_status FROM " . DB_PREFIX . "order_product_serial_numbers opsn JOIN " . DB_PREFIX . "order_product op ON (opsn.order_product_id = op.order_product_id) JOIN " . DB_PREFIX . "order o ON(op.order_id = o.order_id) JOIN " . DB_PREFIX . "order_history oh ON(o.order_id = oh.order_id) JOIN " . DB_PREFIX . "order_status os ON(oh.order_status_id = os.order_status_id) WHERE opsn.serial = '" . $serial . "' ORDER BY o.order_id")->rows;
	}

	public function addProductSerials(int $product_id, string $product_serial): void
	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "product_serial_numbers SET product_id = '" . $product_id . "', serial = '" . $product_serial . "'");
	}


	public function deleteProductSerials(int $product_id): void
	{
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_serial_numbers WHERE product_id = '" . $product_id . "'");
	}



	public function addOrderProductSerials(int $product_id, string $product_serial, int $found): void
	{
		$this->db->query("INSERT INTO " . DB_PREFIX . "order_product_serial_numbers SET order_product_id = '" . $product_id . "', serial = '" . $product_serial . "' , found = '" . $found . "'");
	}



	public function getOrderProductSerials(int $product_id): array
	{
		return $this->db->query("SELECT serial FROM " . DB_PREFIX . "order_product_serial_numbers WHERE order_product_id = '" . $product_id . "'")->rows;
	}

	public function fetchOrderProductSerials(int $product_id): array
	{
		return $this->db->query("SELECT serial FROM " . DB_PREFIX . "order_product_serial_numbers WHERE order_product_id = '" . $product_id . "' AND found = 1")->rows;
	}


	public function deleteOrderProductSerials(int $product_id): void
	{
		$this->db->query("DELETE FROM " . DB_PREFIX . "order_product_serial_numbers WHERE order_product_id = '" . $product_id . "'");
	}

	public function deleteProductSerialsByOrder(string $serial): void
	{
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_serial_numbers WHERE serial = '" . $serial . "'");
	}

	public function getProductsWithSerials(): array
	{
		$query = $this->db->query("
			SELECT 
				p.product_id, 
				pd.name AS product_name, 
				psn.serial 
			FROM " . DB_PREFIX . "product_serial_numbers psn
			INNER JOIN " . DB_PREFIX . "product p ON psn.product_id = p.product_id
			INNER JOIN " . DB_PREFIX . "product_description pd ON p.product_id = pd.product_id
			WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'
		");

		$result = [];

		foreach ($query->rows as $row) {
			$productId = $row['product_id'];
			if (!isset($result[$productId])) {
				$result[$productId] = [
					'product_name' => $row['product_name'],
					'serials' => []
				];
			}

			$result[$productId]['serials'][] = $row['serial'];
		}

		return $result;
	}


}
