<?php

namespace Opencart\Catalog\Controller\Extension\productOrderSerialNumber\Module;

class SerialNumber extends \Opencart\System\Engine\Controller
{
    private function write($message) {

        fwrite(fopen(DIR_LOGS . 'serials.log', 'a'), date('Y-m-d G:i:s') . ' - ' . print_r($message, true) . "\n");
    }

    protected function updateOrderProductSerialNumbers($old_order_products, $new_order_products, $order_id )
    {
        // update order products serial numbers with updated order product ids
        foreach ($new_order_products as $new_order_product) {
            
            $new_order_product_id       = $new_order_product['order_product_id'];
            $order_new_product_id       = $new_order_product['product_id'];
            $order_new_product_quantity = $new_order_product['quantity'];  

            if($old_order_products){

                foreach ($old_order_products as $old_order_product) {

                    if($order_new_product_id == $old_order_product['product_id']){
                        // update order product serial numbers with updated order product ids
                        $this->db->query("UPDATE ".DB_PREFIX."order_product_serial_numbers SET order_product_id = '".$new_order_product_id."' WHERE order_product_id = '".$old_order_product['order_product_id']."' LIMIT ".$order_new_product_quantity." ");
                    }
                }
            }
        }

        // fetch and restore products serials 
        foreach ($new_order_products as $new_order_product){
            
            if($old_order_products){

                foreach ($old_order_products as $old_order_product){                  
                    // remaining old order product ids in order_product_serial_numbers table
                    $old_order_product_ids = $this->db->query("SELECT order_product_id FROM ".DB_PREFIX."order_product_serial_numbers WHERE found = 1 and order_product_id=".$old_order_product['order_product_id'])->rows;
                    
                    $this->restoreProductSerials($old_order_product['order_product_id'], $old_order_product['product_id'], $old_order_product['name'],  $order_id);

                }
            }

        }
    }

    protected function restoreProductSerials($old_order_product_id, $product_id, $product_name, $order_id){

        $serials = $this->db->query("SELECT serial FROM ".DB_PREFIX."order_product_serial_numbers WHERE found = 1 and order_product_id=".$old_order_product_id);

        // get order product all serials
        $products_serials = $this->db->query("SELECT serial FROM ".DB_PREFIX."order_product_serial_numbers WHERE order_product_id = ".$old_order_product_id);

        // restore product serials to product 
        foreach ($serials->rows as $value) {
            $this->db->query("INSERT into ".DB_PREFIX."product_serial_numbers set serial= '".$value['serial']."', product_id=".$product_id);
        }

        // make log entry for removal of order product serial 
        foreach ($products_serials->rows as $value) {
            
            $this->write('Product('.$product_name.') serial "'.$value['serial'].'" is removed from Order# '.$order_id );
        }

        // delete old order product serial numbers
        // $this->db->query("DELETE  FROM ".DB_PREFIX."order_product_serial_numbers WHERE order_product_id=".$old_order_product_id);

    }

    public function autoOrderSerial(string &$route, array &$args) {
        if (isset($args[0])) {
            $order_id = $args[0];
        } else {
            $order_id = 0;
        }

        $this->load->model('checkout/order');
        $order_products = $this->model_checkout_order->getProducts($order_id);

        $apply_auto_serial = $this->config->get('module_serial_number_auto_order_product_serial');

        foreach ($order_products as $key => $value) {
            $string = array();
                
            $p_id = $order_products[$key]['order_product_id'];
            $p_qty = $order_products[$key]['quantity'];

            $product = $this->db->query("SELECT product_id FROM ".DB_PREFIX."order_product WHERE order_product_id = $p_id")->row;

            $product_serial = $this->db->query("SELECT distinct psn.serial FROM ".DB_PREFIX."order o JOIN ".DB_PREFIX."order_product op ON(o.order_id = op.order_id) JOIN ".DB_PREFIX."product_serial_numbers psn ON(op.product_id = psn.product_id) WHERE psn.product_id = ".$product['product_id']."")->rows;

            if ($apply_auto_serial == 1) {
                //apply product serials
                if ($product_serial) {
                    foreach ($product_serial as $key0 => $value0) {
                        $order_products[$key]['serial'] = $product_serial[$key0]['serial'];

                        if ($key0 < $p_qty) {
                            $serial = $order_products[$key]['serial'];

                            $query = "INSERT INTO ".DB_PREFIX."order_product_serial_numbers SET order_product_id = '".$p_id."', serial = '".$serial."'";
                            $this->log->write("Insert Serial: " . $query);

                            $this->db->query("INSERT INTO ".DB_PREFIX."order_product_serial_numbers SET order_product_id = '".$p_id."', serial = '".$serial."'");

                            $this->db->query("DELETE FROM ".DB_PREFIX."product_serial_numbers WHERE serial = '".$serial."'");

                            array_push($string, $value0['serial']);
                        }
                    }
                } else {
                    $order_products[$key]['serial'] = '';
                }

                $order_products[$key]['serial'] = implode(", ", $string);
            } else {
                $order_products[$key]['serial'] = '';
            }
        }
    }

    public function addOrderSerial(string $route, array &$args, &$output) {
        $order_id = $args[0];

        // get order updated products
        $new_order_products = $this->db->query("SELECT order_product_id, product_id, quantity FROM " . DB_PREFIX . "order_product WHERE order_id = '" . $order_id . "' ")->rows;

        $old_order_products = $this->db->query("SELECT order_product_id, product_id, name FROM " . DB_PREFIX . "order_product WHERE order_id = '" . $order_id . "'")->rows;

        if($new_order_products && $old_order_products){
            //update order product serial numbers with update order product ids
            $this->updateOrderProductSerialNumbers($old_order_products, $new_order_products, $order_id);
        }
    }
    
    public function index()
    {
        if (!$this->customer->isLogged()) {
            $this->session->data['redirect'] = $this->url->link('account/order', 'language=' . $this->config->get('config_language'), true);

            $this->response->redirect($this->url->link('account/login', 'language=' . $this->config->get('config_language'), true));
        }

        $customer_id = $this->customer->isLogged();

        $this->load->language('account/order');
        $this->load->language('extension/productOrderSerialNumber/module/serial_number');

        $this->document->setTitle($this->language->get('heading_title'));
        
        $url = '';
        
        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home', 'language=' . $this->config->get('config_language'))
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_account'),
            'href' => $this->url->link('account/account', 'language=' . $this->config->get('config_language') . '&customer_token=' . $this->session->data['customer_token'])
        ];
        
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('account/order', 'language=' . $this->config->get('config_language') . '&customer_token=' . $this->session->data['customer_token'] . $url)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('find_order'),
            'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number', 'language=' . $this->config->get('config_language') . '&customer_token=' . $this->session->data['customer_token'] . $url)
        ];

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['orders'] = array();

        //find order by serial
        if (isset($this->request->get['filter_order_serial'])) {
            $this->load->model('extension/productOrderSerialNumber/module/serial_number');

            $data['filter_order_serial'] = trim($this->request->get['filter_order_serial']);

            if (!empty($data['filter_order_serial'])) {
                $data['orders'] = $this->model_extension_productOrderSerialNumber_module_serial_number->getOrdersByProductSerial($data['filter_order_serial'], $customer_id);

                if ($data['orders']) {
                    $data['order_total_products'] = $this->model_extension_productOrderSerialNumber_module_serial_number->getTotalOrderProductsByOrderId($data['orders'][0]['order_id']);

                    $data['orders'][0]['total_products'] = $data['order_total_products'];
                    $data['orders'][0]['total'] = $this->currency->format($data['orders'][0]['total'], $data['orders'][0]['currency_code'], $data['orders'][0]['currency_value']);
                    $data['orders'][0]['view'] = $this->url->link('account/order.info', 'language=' . $this->config->get('config_language') . '&customer_token=' . $this->session->data['customer_token'] . '&order_id=' . $data['orders'][0]['order_id']);

                } else {
                    $data['no_result'] = 'No record found ';
                }
            }
        } else {
            $data['filter_order_serial'] = '';
        }

        $data['save'] = $this->url->link('extension/productOrderSerialNumber/module/serial_number', 'language=' . $this->config->get('config_language') . '&customer_token=' . $this->session->data['customer_token'] . $url);

        $data['continue'] = $this->url->link('account/account', 'language=' . $this->config->get('config_language') . '&customer_token=' . $this->session->data['customer_token']);
        
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');
        
        $this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/orders_by_serial_number', $data));
    }
}